#include "Sphere.h"

Sphere::Sphere()
{
}

Sphere::Sphere(GLuint texture, float lat, float lon, float r)
{
	Generate(texture, lat, lon, r);
}

Sphere::~Sphere()
{
}

void Sphere::Generate(GLuint texture, float lat, float lon, float r)
{
	_Texture = texture;

	double theta = (2.0f * PI) / lat;
	double delta = (PI) / lon;

	for (double i = 0; i < lon; i++)
	{
		for (double j = 0; j < lat; j++)
		{
			//Vertex calculations
			Vector3 topLeft = Vector3((r * cosf(theta * i)) * sinf(delta * j), r * cosf(delta * j), ((r * sinf(theta * i)) * sinf(delta * j)));
			Vector3 bottomLeft = Vector3((r * cosf(theta * i)) * sinf(delta * (j + 1.0f)), r * cosf(delta * (j + 1.0f)), ((r * sinf(theta * i)) * sinf(delta * (j + 1.0f))));
			Vector3 bottomRight = Vector3((r * cosf(theta * (i + 1.0f))) * sinf(delta * (j + 1.0f)), r * cosf(delta * (j + 1.0f)), ((r * sinf(theta * (i + 1.0f))) * sinf(delta * (j + 1.0f))));
			Vector3 topRight = Vector3((r * cosf(theta * (i + 1.0f))) * sinf(delta * j), r * cosf(delta * j), ((r * sinf(theta * (i + 1.0f))) * sinf(delta * j)));

			//Push normals, UVs and vertex coordinates for each edge
			_Normals.push_back(topLeft.x / r);
			_Normals.push_back(topLeft.y / r);
			_Normals.push_back(topLeft.z / r);
			_TextureCoords.push_back(1.0f - (i / lon));
			_TextureCoords.push_back(1.0f - (j / lat));
			_Vertices.push_back(topLeft.x);
			_Vertices.push_back(topLeft.y);
			_Vertices.push_back(topLeft.z);

			_Normals.push_back(topRight.x / r);
			_Normals.push_back(topRight.y / r);
			_Normals.push_back(topRight.z / r);
			_TextureCoords.push_back(1.0f - ((i + 1.0f) / lon));
			_TextureCoords.push_back(1.0f - (j / lat));
			_Vertices.push_back(topRight.x);
			_Vertices.push_back(topRight.y);
			_Vertices.push_back(topRight.z);

			_Normals.push_back(bottomRight.x / r);
			_Normals.push_back(bottomRight.y / r);
			_Normals.push_back(bottomRight.z / r);
			_TextureCoords.push_back(1.0f - ((i + 1.0f) / lon));
			_TextureCoords.push_back(1.0f - (j + 1.0f) / lat);
			_Vertices.push_back(bottomRight.x);
			_Vertices.push_back(bottomRight.y);
			_Vertices.push_back(bottomRight.z);

			_Normals.push_back(bottomLeft.x / r);
			_Normals.push_back(bottomLeft.y / r);
			_Normals.push_back(bottomLeft.z / r);
			_TextureCoords.push_back(1.0f - (i / lon));
			_TextureCoords.push_back(1.0f - ((j + 1.0f) / lat));
			_Vertices.push_back(bottomLeft.x);
			_Vertices.push_back(bottomLeft.y);
			_Vertices.push_back(bottomLeft.z);
		}
	}
}